## Member Attributes

Member attributes allows for quickly defining derived hierarchies from the base/default hierarchy (e.g., customer eMail). The advantage of using attributes relates to improving performance, especially in large crossjoins.




### Description

Let's take an example to illustrate member attributes by creating an imaginary `Employee` dimension.

This dimension contains a base hierarchy organizing `Employee ID` within `Department` within `Company`. Then we'd like to have an extra (flat) hierarchy for each available attribute of those members: e.g., name, first-name, eMail, country, etc...

The base hierarchy is defined as usual with the following levels:

<pre>
(D) Employee                          : from table EMPLOYEE
        (H) Employee ID
                (L) All
                (L) Company           : from table column EMPLOYEE_COMPANY
                (L) Department        : from table column EMPLOYEE_DEPARTMENT
                (L) Employee ID       : from table column EMPLOYEE_ID
</pre>

Then within the last level `Employee ID` we can add attributes:

<pre>
Name                                  : from table column EMPLOYEE_NAME
First Name                            : from table column EMPLOYEE_FIRST_NAME
eMail                                 : from table column EMPLOYEE_EMAIL
Country                               : from table column EMPLOYEE_COUNTRY
</pre>

This will create the extra hierarchies as following:

<pre>
(D) Employee                          : from table EMPLOYEE
        (H) Employee ID
                (L) All
                (L) Company           : from table column EMPLOYEE_COMPANY
                (L) Department        : from table column EMPLOYEE_DEPARTMENT
                (L) Employee ID       : from table column EMPLOYEE_ID
        (H) Name
                (L) All
                (L) Name              : from table column EMPLOYEE_NAME
        (H) First Name
                (L) All
                (L) First Name        : from table column EMPLOYEE_FIRST_NAME
        (H) eMail
                (L) All
                (L) eMail             : from table column EMPLOYEE_EMAIL
        (H) Country
                (L) All
                (L) Country           : from table column EMPLOYEE_COUNTRY
</pre>

Attributes can be created within levels of the base/default hierarchy only. They imply a one-to-many relation with the level defining them (e.g., each `Employee` has a unique name but the same name might be shared by more than one employee).

Attributes can handle empty or null attributes with the `If Null/Empty Name` field. This member will be created with a name and no key and is linked with an actual member of the base hierarchy. Do not confuse with the unknown member that is used for facts binding when no matching key is found. This member can be sorted using the order field in the level defining the hierarchy.

Attributes are improving performances for typical auto-exist in large crossjoins. Indeed, the following crossjoin can be very large even if the size of the actual result is the number of employee only:

<pre>
[Employee ID] * [Name] * [First Name] * [eMail] * [Country]
</pre>

Note that attributes are similar to member properties, but they can be used directly in `SELECT` statements as any other regular member. When needed, they can be accessed via the `GetProperty()` and `Properties()` functions.

At schema level there is an auto-attribute flag. If active, icCube will try to find this one-to-many relation with the last level of the base hierarchy for non-base hierarchies. If they exist, these relations will not define a property but allow for faster auto-exists.



                                                                      

### See Also


[Member Custom Property](Member%20Custom%20Property.md)

[Properties](Properties.md)

[GetProperty](GetProperty.md)

[GetPropertyUniqueValues](GetPropertyUniqueValues.md)

[Dimension Properties](Dimension%20Properties.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
